﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

//Constants is a static class containing constant global variables
public static class Constants
{
    //Enums
    public enum Settings
    {
        MusicVolume,
        SFXVolume,
        VehicleVolume
    }

    public enum AudioType
    {
        SFX,
        Music,
        Sentinel
    }

    [System.Serializable]
    public enum CarType
    {
        LowEnd,
        MediumEnd,
        HighEnd
    }

    public enum InGameMenus
    {
        Pause,
        CarSelection,
        Mission,
        None
    }

    public enum MissionDifficulties
    {
        Easy,
        Medium,
        Hard,
        Sentinel
    }
    
    public enum GameState
    {
        Playing,
        Paused,
        ShowingCarSelection,
        ShowingMissionInfo
    }

    public static KeyCode InteractKeyCode = KeyCode.E;  //Constant code for interaction - could be tied to a key binding UI in future

    public static LoadTask LoadTask;    //The task to perform while on LoadingScene

    //Paths
    public static string SettingsXMLFilePath = Application.persistentDataPath + @"/Settings.xml";

    //Sentinel values
    public static Vector2 SentinelVector2 = new Vector2(-1000.0f, -1000.0f);
    public static Vector3 SentinelVector3 = new Vector3(-1000.0f, -1000.0f, -1000.0f);
    public static Vector3Int SentinelVector3Int = new Vector3Int(-1000, -1000, -1000);

    //Grid/Tilemap
    public static Vector2 GridCellGap = new Vector2(-0.01f, -0.01f);
    public static int TilemapZPosition = 0;

    //IDs
    public static string HorizontalRoadTileID = "horRoad";
    public static string VerticalRoadTileID = "verRoad";
    public static string TopLeftCornerRoadTileID = "topLeftCornerRoad";
    public static string TopRightCornerRoadTileID = "topRightCornerRoad";
    public static string BottomLeftCornerRoadTileID = "bottomLeftCornerRoad";
    public static string BottomRightCornerRoadTileID = "bottomRightCornerRoad";
    public static string TopJunctionRoadTileID = "topJunctionRoad";
    public static string BottomJunctionRoadTileID = "bottomJunctionRoad";
    public static string LeftJunctionRoadTileID = "leftJunctionRoad";
    public static string RightJunctionRoadTileID = "rightJunctionRoad";
    public static string CentreJunctionRoadTileID = "centreJunctionRoad";
    public static string ValidBuildingPlacementTileID = "validBuildingPlacement";
    public static string OccupiedBuildingTileID = "occupiedBuilding";

    //UI IDs
    public static string UIButtonSelectAudioID = "ButtonSelect";
    public static string UIButtonBackAudioID = "ButtonBack";
    public static string UIButtonFocusAudioID = "ButtonFocus";
    public static string UIButtonInactiveSelectAudioID = "ButtonInactiveSelect";
    public static string UIButtonInactiveFocusAudioID = "ButtonInactiveFocus";
    public static string UIPageTransToAudioID = "PageTransTo";
    public static string UIPageTransFromAudioID = "PageTransFrom";
    public static string UIPageTransBackToAudioID = "PageTransBackTo";
    public static string UIPageTransBackFromAudioID = "PageTransBackFrom";

    //Names
    public static string PlayerCarObjectName = "PlayerCar";
    public static string PlayerCarIconName = "PlayerCar";
    public static string TimeTrialDestinationIconName = "TimeTrialDestination";
    public static string WagerRaceDestinationIconName = "WagerRaceDestination";
    public static string CollectionItemDestinationPrefix = "CollectionItemDestination";
    public static List<string> GarageColliderNames = new List<string>() { "GarageTopCollider", "GarageBottomCollider", "GarageLeftCollider", "GarageRightCollider" };
    public static List<string> BuildingColliderNames = new List<string>() { "BuildingTopCollider", "BuildingBottomCollider", "BuildingLeftCollider", "BuildingRightCollider" };
}
